/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWReplyParamPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class VWReplyGeneralPanel
extends JPanel {
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_VALUE = 2;
    protected VWReplyParamPanel m_parent = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private VWInstructionDefinition m_instructionDef = null;
    private JTextField m_partnerLink = null;
    private JTextField m_operation = null;
    private JTextField m_messageType = null;
    private JPanel m_basicPanel = null;
    private JPanel m_advancedPanel = null;
    private JPanel m_faultPanel = null;
    private VWWebServiceParameterDefinition[] m_replyParams = null;
    private String[] m_replyParamsTableColumnNames = new String[]{VWResource.s_name, VWResource.s_type, VWResource.s_fieldName};
    private VWTable m_replyParamsTable = null;
    private AbstractTableModel m_replyParamsTableModel = null;
    private JTextField m_replySchema = null;
    private JTextField m_replyElement = null;
    private JTextArea m_advancedOutgoingMessage = null;
    private JTextField m_replyFault = null;
    private JTextArea m_faultOutgoingMessage = null;

    public VWReplyGeneralPanel(VWReplyParamPanel parent, DefaultTableCellRenderer tableCellRenderer, VWInstructionDefinition instruction) {
        this.m_parent = parent;
        this.m_tableCellRenderer = tableCellRenderer;
        this.m_instructionDef = instruction;
        this.setupLayout();
    }

    public void setInstructionDefinition(VWReplyInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        JLabel partnerLinkLabel = new JLabel(VWResource.s_partnerLink);
        this.m_partnerLink = new JTextField();
        this.m_partnerLink.setEditable(false);
        this.m_partnerLink.setBorder(null);
        JPanel partnerLinkPanel = new JPanel(new BorderLayout(10, 0));
        partnerLinkPanel.add((Component)partnerLinkLabel, "Before");
        partnerLinkPanel.add((Component)this.m_partnerLink, "Center");
        JLabel operationLabel = new JLabel(VWResource.s_operationColon);
        this.m_operation = new JTextField();
        this.m_operation.setEditable(false);
        this.m_operation.setBorder(null);
        JPanel operationPanel = new JPanel(new BorderLayout(10, 0));
        operationPanel.add((Component)operationLabel, "Before");
        operationPanel.add((Component)this.m_operation, "Center");
        JLabel modeLabel = new JLabel(VWResource.s_messageType);
        this.m_messageType = new JTextField();
        this.m_messageType.setEditable(false);
        this.m_messageType.setBorder(null);
        JPanel messageTypePanel = new JPanel(new BorderLayout(10, 0));
        messageTypePanel.add((Component)modeLabel, "Before");
        messageTypePanel.add((Component)this.m_messageType, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)partnerLinkPanel, c);
        c.gridy = -1;
        this.add((Component)operationPanel, c);
        c.gridy = -1;
        this.add((Component)messageTypePanel, c);
        this.m_basicPanel = this.createBasicPanel();
        this.m_advancedPanel = this.createAdvancedPanel();
        this.m_faultPanel = this.createFaultPanel();
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)this.m_basicPanel, c);
        this.add((Component)this.m_advancedPanel, c);
        this.add((Component)this.m_faultPanel, c);
        this.m_advancedPanel.setVisible(false);
        this.m_basicPanel.setVisible(false);
        this.m_faultPanel.setVisible(false);
    }

    private JPanel createBasicPanel() {
        VWToolbarBorder paramsBorder = new VWToolbarBorder(VWResource.s_operationParameters, 0);
        JPanel paramsPanel = paramsBorder.getClientPanel();
        paramsPanel.setLayout(new BorderLayout());
        paramsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_replyParamsTable = new VWTable();
        this.m_replyParamsTable.setRowSelectionAllowed(true);
        this.m_replyParamsTable.setColumnSelectionAllowed(false);
        this.m_replyParamsTable.setSelectionMode(0);
        paramsPanel.add((Component)new JScrollPane(this.m_replyParamsTable), "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)paramsBorder, c);
        return panel;
    }

    private JPanel createAdvancedPanel() {
        VWToolbarBorder outgoingMsgBorder = new VWToolbarBorder(VWResource.s_outgoingMessage, 0);
        JPanel outgoingMsgPanel = outgoingMsgBorder.getClientPanel();
        outgoingMsgPanel.setLayout(new BorderLayout());
        outgoingMsgPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_advancedOutgoingMessage = new JTextArea();
        this.m_advancedOutgoingMessage.setEditable(false);
        this.m_advancedOutgoingMessage.setBorder(null);
        outgoingMsgPanel.add((Component)new JScrollPane(this.m_advancedOutgoingMessage), "Center");
        JLabel schemaLabel = new JLabel(VWResource.s_schema);
        this.m_replySchema = new JTextField();
        this.m_replySchema.setEditable(false);
        this.m_replySchema.setBorder(null);
        JPanel schemaPanel = new JPanel(new BorderLayout(10, 0));
        schemaPanel.add((Component)schemaLabel, "Before");
        schemaPanel.add((Component)this.m_replySchema, "Center");
        JLabel elementLabel = new JLabel(VWResource.s_element);
        this.m_replyElement = new JTextField();
        this.m_replyElement.setEditable(false);
        this.m_replyElement.setBorder(null);
        JPanel elementPanel = new JPanel(new BorderLayout(10, 0));
        elementPanel.add((Component)elementLabel, "Before");
        elementPanel.add((Component)this.m_replyElement, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.gridy = -1;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)outgoingMsgBorder, c);
        c.weighty = 0.0;
        c.fill = 2;
        panel.add((Component)schemaPanel, c);
        c.weighty = 1.0;
        panel.add((Component)elementPanel, c);
        return panel;
    }

    private JPanel createFaultPanel() {
        JLabel faultLabel = new JLabel(VWResource.s_faultName);
        this.m_replyFault = new JTextField();
        this.m_replyFault.setEditable(false);
        this.m_replyFault.setBorder(null);
        JPanel faultPanel = new JPanel(new BorderLayout(10, 0));
        faultPanel.add((Component)faultLabel, "Before");
        faultPanel.add((Component)this.m_replyFault, "Center");
        VWToolbarBorder outgoingMsgBorder = new VWToolbarBorder(VWResource.s_outgoingMessage, 0);
        JPanel outgoingMsgPanel = outgoingMsgBorder.getClientPanel();
        outgoingMsgPanel.setLayout(new BorderLayout());
        outgoingMsgPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_faultOutgoingMessage = new JTextArea();
        this.m_faultOutgoingMessage.setEditable(false);
        this.m_faultOutgoingMessage.setBorder(null);
        outgoingMsgPanel.add((Component)new JScrollPane(this.m_faultOutgoingMessage), "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        c.gridy = -1;
        panel.add((Component)faultPanel, c);
        c.weighty = 1.0;
        c.fill = 1;
        panel.add((Component)outgoingMsgBorder, c);
        return panel;
    }

    private void reinitialize() {
        try {
            int i;
            this.m_replyParamsTableModel = null;
            this.m_advancedPanel.setVisible(false);
            this.m_basicPanel.setVisible(false);
            this.m_faultPanel.setVisible(false);
            String partnerLink = ((VWReplyInstruction)this.m_instructionDef).getPartnerLinkName();
            this.m_parent.setTextField(this.m_partnerLink, partnerLink);
            String operation = ((VWReplyInstruction)this.m_instructionDef).getOperationName();
            this.m_parent.setTextField(this.m_operation, operation);
            int mode = this.m_parent.getReplyMessageType();
            if (mode == 2) {
                this.m_parent.setTextField(this.m_messageType, VWResource.s_fault);
                this.m_faultPanel.setVisible(true);
            } else if (mode == 0) {
                this.m_parent.setTextField(this.m_messageType, VWResource.s_message);
                this.m_basicPanel.setVisible(true);
            } else if (mode == 1) {
                this.m_parent.setTextField(this.m_messageType, VWResource.s_message);
                this.m_advancedPanel.setVisible(true);
            }
            String elementMsg = ((VWReplyInstruction)this.m_instructionDef).getMessageFromElementName();
            this.m_parent.setTextField(this.m_replyElement, elementMsg);
            String schemaMsg = ((VWReplyInstruction)this.m_instructionDef).getMessageFromSchemaName();
            this.m_parent.setTextField(this.m_replySchema, schemaMsg);
            String outgoingMsg = ((VWReplyInstruction)this.m_instructionDef).getMessageExpr();
            this.m_faultOutgoingMessage.setText(outgoingMsg);
            this.m_advancedOutgoingMessage.setText(outgoingMsg);
            String faultName = ((VWReplyInstruction)this.m_instructionDef).getFaultName();
            this.m_parent.setTextField(this.m_replyFault, faultName);
            VWWebServiceParameterDefinition[] paramDefs = ((VWReplyInstruction)this.m_instructionDef).getParameterDefinitions();
            Vector<VWWebServiceParameterDefinition> rows = new Vector<VWWebServiceParameterDefinition>();
            if (paramDefs != null) {
                for (i = 0; i < paramDefs.length; ++i) {
                    if (i < paramDefs.length - 1 && paramDefs[i].getLexicalLevel() < paramDefs[i + 1].getLexicalLevel()) continue;
                    rows.addElement(paramDefs[i]);
                }
            }
            this.m_replyParams = new VWWebServiceParameterDefinition[rows.size()];
            for (i = 0; i < rows.size(); ++i) {
                VWWebServiceParameterDefinition paramItem = (VWWebServiceParameterDefinition)rows.elementAt(i);
                if (paramItem == null) continue;
                this.m_replyParams[i] = paramItem;
            }
            if (this.m_replyParams != null) {
                if (this.m_replyParamsTableModel == null) {
                    this.m_replyParamsTableModel = new AbstractTableModel(){

                        public boolean isCellEditable(int row, int col) {
                            return false;
                        }

                        public String getColumnName(int nColumnIndex) {
                            switch (nColumnIndex) {
                                case 0: {
                                    return VWReplyGeneralPanel.this.m_replyParamsTableColumnNames[0];
                                }
                                case 1: {
                                    return VWReplyGeneralPanel.this.m_replyParamsTableColumnNames[1];
                                }
                                case 2: {
                                    return VWReplyGeneralPanel.this.m_replyParamsTableColumnNames[2];
                                }
                            }
                            return null;
                        }

                        public int getColumnCount() {
                            return VWReplyGeneralPanel.this.m_replyParamsTableColumnNames.length;
                        }

                        public int getRowCount() {
                            if (VWReplyGeneralPanel.this.m_replyParams != null) {
                                return VWReplyGeneralPanel.this.m_replyParams.length;
                            }
                            return 0;
                        }

                        public Object getValueAt(int nRowIndex, int nColumnIndex) {
                            try {
                                if (VWReplyGeneralPanel.this.m_replyParams != null && nRowIndex >= 0 && nRowIndex < VWReplyGeneralPanel.this.m_replyParams.length) {
                                    VWWebServiceParameterDefinition paramDef = VWReplyGeneralPanel.this.m_replyParams[nRowIndex];
                                    if (paramDef == null) {
                                        return null;
                                    }
                                    switch (nColumnIndex) {
                                        case 0: {
                                            return paramDef.getName();
                                        }
                                        case 1: {
                                            return VWReplyGeneralPanel.this.m_parent.getTypeFromParam(paramDef);
                                        }
                                        case 2: {
                                            return paramDef.getValue();
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                            }
                            return null;
                        }
                    };
                    this.m_replyParamsTable.setModel(this.m_replyParamsTableModel);
                }
                this.m_parent.setupTableCellRenderer(this.m_replyParamsTable, this.m_replyParamsTableModel);
                this.m_replyParamsTableModel.fireTableDataChanged();
                this.m_replyParamsTable.fitColumnsInTable();
                this.m_replyParamsTable.updateUI();
            }
            this.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeReferences() {
        int i;
        this.m_partnerLink = null;
        this.m_operation = null;
        this.m_messageType = null;
        this.m_replySchema = null;
        this.m_replyElement = null;
        this.m_advancedOutgoingMessage = null;
        this.m_faultOutgoingMessage = null;
        this.m_replyFault = null;
        if (this.m_replyParams != null) {
            for (i = 0; i < this.m_replyParams.length; ++i) {
                this.m_replyParams[i] = null;
            }
        }
        for (i = 0; i < this.m_replyParamsTableColumnNames.length; ++i) {
            this.m_replyParamsTableColumnNames[i] = null;
        }
        if (this.m_replyParamsTable != null) {
            this.m_replyParamsTable.removeReferences();
            this.m_replyParamsTable = null;
        }
        this.m_basicPanel = null;
        this.m_advancedPanel = null;
        this.m_faultPanel = null;
        this.m_parent = null;
        this.m_tableCellRenderer = null;
        this.m_instructionDef = null;
    }
}

